/*
 * Decompiled with CFR 0.152.
 */
package technology.rocketjump.undermount.mapgen.generators;

import com.badlogic.gdx.math.GridPoint2;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Random;
import java.util.TreeSet;
import technology.rocketjump.undermount.mapgen.calculators.RiverPathfindingCalculator;
import technology.rocketjump.undermount.mapgen.model.TileType;
import technology.rocketjump.undermount.mapgen.model.output.CompassDirection;
import technology.rocketjump.undermount.mapgen.model.output.GameMap;
import technology.rocketjump.undermount.mapgen.model.output.GameMapTile;
import technology.rocketjump.undermount.mapgen.model.output.MapEdgeSection;
import technology.rocketjump.undermount.mapgen.model.output.MapRegion;

public class RiverGenerator {
    public boolean addRiver(GameMap map, Random random) {
        MapEdgeSection endEdge;
        MapEdgeSection startEdge;
        MapRegion regionToUse = this.pickRegionToUse(map);
        if (regionToUse == null || regionToUse.edgeDirections.size() <= 1) {
            return false;
        }
        ArrayList<CompassDirection> edgeDirectionList = new ArrayList<CompassDirection>();
        edgeDirectionList.addAll(regionToUse.edgeDirections);
        if (edgeDirectionList.size() == 2) {
            do {
                startEdge = regionToUse.edges.get(random.nextInt(regionToUse.edges.size()));
                endEdge = regionToUse.edges.get(random.nextInt(regionToUse.edges.size()));
            } while (startEdge.direction == endEdge.direction);
        } else {
            do {
                startEdge = regionToUse.edges.get(random.nextInt(regionToUse.edges.size()));
                endEdge = regionToUse.edges.get(random.nextInt(regionToUse.edges.size()));
            } while (!startEdge.direction.isOppositeTo(endEdge.direction));
        }
        startEdge = this.trimEdge(startEdge);
        endEdge = this.trimEdge(endEdge);
        GridPoint2 startPoint = new GridPoint2(startEdge.minimum.x + random.nextInt(startEdge.maximum.x - startEdge.minimum.x + 1), startEdge.minimum.y + random.nextInt(startEdge.maximum.y - startEdge.minimum.y + 1));
        GridPoint2 endPoint = new GridPoint2(endEdge.minimum.x + random.nextInt(endEdge.maximum.x - endEdge.minimum.x + 1), endEdge.minimum.y + random.nextInt(endEdge.maximum.y - endEdge.minimum.y + 1));
        return this.runRiver(startPoint, endPoint, map);
    }

    private boolean runRiver(GridPoint2 startPoint, GridPoint2 endPoint, GameMap map) {
        RiverPathfindingCalculator pathfinder = new RiverPathfindingCalculator(startPoint, endPoint, map);
        List<GridPoint2> path = pathfinder.findPath();
        if (path.size() == 0) {
            System.err.println("Could not find a suitable path for river in " + this.getClass().getName());
            return false;
        }
        ArrayList<GridPoint2> riverTiles = new ArrayList<GridPoint2>();
        for (int cursor = 0; cursor < path.size(); ++cursor) {
            GridPoint2 riverPoint = path.get(cursor);
            GameMapTile tile = map.get(riverPoint);
            tile.setRiver(true);
            riverTiles.add(riverPoint);
        }
        map.setRiver(riverTiles);
        map.getRiverStartTiles().add(path.get(0));
        map.getRiverEndTiles().add(path.get(path.size() - 1));
        return true;
    }

    private MapEdgeSection trimEdge(MapEdgeSection original) {
        MapEdgeSection result = new MapEdgeSection(original);
        result.minimum.x = original.minimum.x + (original.maximum.x - original.minimum.x) * 10 / 100;
        result.maximum.x = original.maximum.x - (original.maximum.x - original.minimum.x) * 10 / 100;
        result.minimum.y = original.minimum.y + (original.maximum.y - original.minimum.y) * 10 / 100;
        result.maximum.y = original.maximum.y - (original.maximum.y - original.minimum.y) * 10 / 100;
        return result;
    }

    private MapRegion pickRegionToUse(GameMap map) {
        TreeSet<MapRegion> sortedOutdoorRegions = new TreeSet<MapRegion>(new Comparator<MapRegion>(){

            @Override
            public int compare(MapRegion r1, MapRegion r2) {
                if (r1.edgeDirections.size() == r2.edgeDirections.size()) {
                    return r2.getNumBorderTiles() - r1.getNumBorderTiles();
                }
                return r2.edgeDirections.size() - r1.edgeDirections.size();
            }
        });
        for (MapRegion region : map.getRegions().values()) {
            if (!region.getTileType().equals((Object)TileType.OUTSIDE) || region.edgeDirections.size() <= 0) continue;
            sortedOutdoorRegions.add(region);
        }
        return (MapRegion)sortedOutdoorRegions.iterator().next();
    }

    public void ensureRiverEndpoints(GameMap gameMap, int radius) {
        GameMapTile gameMapTile;
        int offsetY;
        int offsetX;
        if (gameMap.getRiverStartTiles().isEmpty()) {
            return;
        }
        GridPoint2 startTilePosition = gameMap.getRiverStartTiles().get(0);
        for (offsetX = -radius; offsetX <= radius; ++offsetX) {
            for (offsetY = -radius; offsetY <= radius; ++offsetY) {
                gameMapTile = gameMap.get(startTilePosition.x + offsetX, startTilePosition.y + offsetY);
                if (gameMapTile == null || !gameMapTile.hasRiver() || !gameMapTile.isBorderTile()) continue;
                gameMap.getRiverStartTiles().add(gameMapTile.getPosition());
            }
        }
        startTilePosition = gameMap.getRiverEndTiles().get(0);
        for (offsetX = -radius; offsetX <= radius; ++offsetX) {
            for (offsetY = -radius; offsetY <= radius; ++offsetY) {
                gameMapTile = gameMap.get(startTilePosition.x + offsetX, startTilePosition.y + offsetY);
                if (gameMapTile == null || !gameMapTile.hasRiver() || !gameMapTile.isBorderTile()) continue;
                gameMap.getRiverEndTiles().add(gameMapTile.getPosition());
            }
        }
    }
}

